#ifndef TRUE
#define TRUE   1
#define FALSE  0
#endif

#pragma pack(1)
typedef struct DISK_INFO
     {
	  unsigned char       lo_tno ;
	  unsigned char       hi_tno ;
	  unsigned long       lead_out ;
     } DISK_INFO ;

typedef struct QCHAN_INFO
     {
	  unsigned char       tno ;
	  unsigned char       reserved0 ;
	  unsigned char       min ;
	  unsigned char       sec ;
	  unsigned char       frame ;
	  unsigned char       reserved1 ;
	  unsigned char       pmin ;
	  unsigned char       psec ;
	  unsigned char       pframe ;
     } QCHAN_INFO ;

#pragma pack()

/*  Function prototypes for CD-ROM Audio Interface routines  */
int sbcd_continue( void ) ;
int sbcd_fastforward( unsigned ) ;
int sbcd_get_aud_status( int far * ) ;
int sbcd_get_disc_info( DISK_INFO far * ) ;
int sbcd_get_loc_info( QCHAN_INFO far * ) ;
int sbcd_get_volume( unsigned long far * ) ;
int sbcd_init( int far * ) ;
int sbcd_media_changed( int far * ) ;
int sbcd_next_track( void ) ;
int sbcd_pause( void ) ;
int sbcd_play( unsigned char, unsigned, unsigned ) ;
int sbcd_prev_track( void ) ;
int sbcd_read_toc( unsigned long far * ) ;
int sbcd_rewind( unsigned ) ;
int sbcd_select_drv( unsigned char ) ;
int sbcd_stop( void ) ;


#define LOWORD(l)       ((unsigned)(l))
#define HIWORD(l)       ((unsigned)(((unsigned long)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)       ((unsigned char)(w))
#define HIBYTE(w)       ((unsigned char)(((unsigned)(w) >> 8) & 0xFF))
